/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.io.Serializable;
import nts.base.Dimen;
import nts.io.Log;
import nts.io.Loggable;

public final class BoxSizes
implements Serializable,
Loggable {
    public static final BoxSizes NULL;
    public static final BoxSizes ZERO;
    private final Dimen height;
    private final Dimen width;
    private final Dimen depth;
    private final Dimen leftX;

    public Dimen rawHeight() {
        return this.height;
    }

    public Dimen rawWidth() {
        return this.width;
    }

    public Dimen rawDepth() {
        return this.depth;
    }

    public Dimen rawLeftX() {
        return this.leftX;
    }

    public Dimen getHeight() {
        return BoxSizes.getSize(this.height);
    }

    public Dimen getWidth() {
        return BoxSizes.getSize(this.width);
    }

    public Dimen getDepth() {
        return BoxSizes.getSize(this.depth);
    }

    public Dimen getLeftX() {
        return BoxSizes.getSize(this.leftX);
    }

    private static Dimen getSize(Dimen x) {
        return x != null ? x : Dimen.ZERO;
    }

    public BoxSizes replenished(BoxSizes around) {
        Dimen h = this.height;
        Dimen w = this.width;
        Dimen d = this.depth;
        Dimen l = this.leftX;
        boolean change = false;
        if (h == null) {
            h = around.getHeight();
            change = true;
        }
        if (w == null) {
            w = around.getWidth();
            change = true;
        }
        if (d == null) {
            d = around.getDepth();
            change = true;
        }
        if (l == null) {
            l = around.getLeftX();
            change = true;
        }
        return change ? new BoxSizes(h, w, d, l) : this;
    }

    public BoxSizes shiftedUp(Dimen shift) {
        return new BoxSizes(this.height != null ? this.height.plus(shift) : this.height, this.width, this.depth != null ? this.depth.minus(shift) : this.depth, this.leftX);
    }

    public BoxSizes shiftedLeft(Dimen shift) {
        return new BoxSizes(this.height, this.width != null ? this.width.minus(shift) : this.width, this.depth, this.leftX != null ? this.leftX.plus(shift) : this.leftX);
    }

    public BoxSizes withHeight(Dimen height) {
        return new BoxSizes(height, this.width, this.depth, this.leftX);
    }

    public BoxSizes withWidth(Dimen width) {
        return new BoxSizes(this.height, width, this.depth, this.leftX);
    }

    public BoxSizes withDepth(Dimen depth) {
        return new BoxSizes(this.height, this.width, depth, this.leftX);
    }

    public BoxSizes withLeftX(Dimen leftX) {
        return new BoxSizes(this.height, this.width, this.depth, leftX);
    }

    public void addOn(Log log) {
        log.add('(');
        BoxSizes.addSize(log, this.height);
        log.add('+');
        BoxSizes.addSize(log, this.depth);
        log.add(")x");
        BoxSizes.addSize(log, this.width);
    }

    private static void addSize(Log log, Dimen x) {
        if (x == null) {
            log.add('*');
        } else {
            log.add(x.toString());
        }
    }

    public BoxSizes(Dimen h, Dimen w, Dimen d, Dimen l) {
        this.height = h;
        this.width = w;
        this.depth = d;
        this.leftX = l;
    }

    static {
        ZERO = new BoxSizes(Dimen.ZERO, Dimen.ZERO, Dimen.ZERO, Dimen.ZERO);
    }
}

