/* vputm.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

#if defined (IF_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

void v_putm (const char *p, int len)
{
  if (len > 0)
    {
#if defined (IF_WIN32)
      IF_WIN32
        {
          DWORD r;
          WriteConsole(            
            GetStdHandle(STD_OUTPUT_HANDLE),
            p,len,&r,NULL);
        }
#endif
#if defined (IF_DOS)
      IF_DOS
        {
          if (_v_mem != NULL)
            {
              char *dst;

              dst = _v_mem + (_v_y * _v_width + _v_x) * 2;
              while (len > 0)
                {
                  dst[0] = *p++;
                  dst[1] = (char)_v_attr;
                  --len; dst += 2;
                }
            }
          else
            {
              int i;
              union REGS r;

              for (i = 0; i < len; ++i)
                {
                  r.h.ah = 0x02;
                  r.h.bh = 0x00;
                  r.h.dl = (unsigned char)_v_x + i;
                  r.h.dh = (unsigned char)_v_y;
                  _int86 (0x10, &r, &r);
                  r.h.ah = 0x09;
                  r.h.bh = 0;
                  r.h.bl = (unsigned char)_v_attr;
                  r.h.al = p[i];
                  r.x.cx = 1;
                  _int86 (0x10, &r, &r);
                }
              r.h.ah = 0x02;
              r.h.bh = 0x00;
              r.h.dl = (unsigned char)_v_x;
              r.h.dh = (unsigned char)_v_y;
              _int86 (0x10, &r, &r);
            }
        }
#endif
    }
}
