/* ttyname.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __ttyname (int fd, char *buf, size_t size)
{
    int ret;
    int type;

    if ((ret = __ioctl2(fd, FGETHTYPE, (int) &type)) < 0)
        return ret;

    if (type == FILE_TYPE_CHAR) {
        static char tty_console[] = "/dev/con";

        if (sizeof(tty_console) > size)
            return _rsxnt_errno(ENAMETOOLONG);
        memcpy(buf, tty_console, sizeof(tty_console));
        return 0;
    }
    else
        return _rsxnt_errno(ENODEV);
}
