/* pipe.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __pipe(int *two_handles, int size)
{
    static SECURITY_ATTRIBUTES defsec =
        { sizeof(SECURITY_ATTRIBUTES), NULL, TRUE };
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    int fdr, fdw;

    if ((fdr = _rsxnt_get_new_file(proc)) < 0)
        return _rsxnt_errno(EMFILE);

    fdw = _rsxnt_get_new_file(proc);
    if (fdw < 0) {
        proc->file[fdr].f_handle = INVALID_HANDLE_VALUE;
        return _rsxnt_errno(EMFILE);
    }

    if (CreatePipe(&proc->file[fdr].f_handle, &proc->file[fdw].f_handle,
                &defsec, size) == FALSE) {
        proc->file[fdr].f_handle = INVALID_HANDLE_VALUE;
        proc->file[fdw].f_handle = INVALID_HANDLE_VALUE;
        return _rsxnt_get_last_errno();
    }

    proc->file[fdr].f_mode = HT_UPIPE;
    proc->file[fdw].f_mode = HT_UPIPE;

    two_handles[0] = fdr;
    two_handles[1] = fdw;

    return 0;
}
