/* newfile.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int _rsxnt_get_new_file(EMXPROCESS *p)
{
    int i;

    EnterCriticalSection(&(p->CritSectFiles));

    for (i = 0; i < N_FILES; i++)
	if (p->file[i].f_handle == INVALID_HANDLE_VALUE) {
	    p->file[i].f_handle = BAD_FS_HANDLE;    /* temp. alloc */
	    break;
	}

    LeaveCriticalSection(&(p->CritSectFiles));

    return (i == N_FILES) ? -1 : i;
}
