/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"renderLinesAnsi", "", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "level", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "hyperlinks", "", "invokeStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "text", "downsample", "style", "makeTag", "old", "new", "makeHyperlinkTag", "hyperlink", "hyperlinkId", "toAnsi", "", "", "Lcom/github/ajalt/colormath/Color;", "select", "reset", "offset", "mordant"})
@SourceDebugExtension(value={"SMAP\nAnsiRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnsiRender.kt\ncom/github/ajalt/mordant/internal/AnsiRenderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class AnsiRenderKt {
    @NotNull
    public static final String renderLinesAnsi(@NotNull Lines lines, @NotNull AnsiLevel level, boolean hyperlinks) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        StringBuilder $this$renderLinesAnsi_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterator iterator2 = ((Iterable)lines.getLines()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Line line = (Line)iterator2.next();
            if (i > 0) {
                $this$renderLinesAnsi_u24lambda_u240.append("\n");
            }
            TextStyle activeStyle = ConstantsKt.getDEFAULT_STYLE();
            for (Span span : line) {
                TextStyle newStyle = AnsiRenderKt.downsample(span.getStyle(), level, hyperlinks);
                $this$renderLinesAnsi_u24lambda_u240.append(AnsiRenderKt.makeTag(activeStyle, newStyle));
                activeStyle = newStyle;
                $this$renderLinesAnsi_u24lambda_u240.append(span.getText());
            }
            $this$renderLinesAnsi_u24lambda_u240.append(AnsiRenderKt.makeTag(activeStyle, ConstantsKt.getDEFAULT_STYLE()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public static final String invokeStyle(@NotNull TextStyle $this$invokeStyle, @NotNull String text2) {
        Intrinsics.checkNotNullParameter($this$invokeStyle, "<this>");
        Intrinsics.checkNotNullParameter(text2, "text");
        if (((CharSequence)text2).length() == 0) {
            return "";
        }
        Ref.ObjectRef openStyle = new Ref.ObjectRef();
        openStyle.element = $this$invokeStyle;
        Ref.ObjectRef style = new Ref.ObjectRef();
        style.element = $this$invokeStyle;
        String inner = ConstantsKt.getANSI_RE().replace((CharSequence)text2, arg_0 -> AnsiRenderKt.invokeStyle$lambda$1(text2, style, $this$invokeStyle, openStyle, arg_0));
        return AnsiRenderKt.makeTag(ConstantsKt.getDEFAULT_STYLE(), (TextStyle)openStyle.element) + inner + AnsiRenderKt.makeTag((TextStyle)style.element, ConstantsKt.getDEFAULT_STYLE());
    }

    @NotNull
    public static final TextStyle downsample(@NotNull TextStyle style, @NotNull AnsiLevel level, boolean hyperlinks) {
        TextStyle textStyle;
        Intrinsics.checkNotNullParameter(style, "style");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        if (style == ConstantsKt.getDEFAULT_STYLE()) {
            textStyle = style;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    textStyle = ConstantsKt.getDEFAULT_STYLE();
                    break;
                }
                case 2: {
                    String string;
                    Color color;
                    Color color2;
                    Color color3;
                    Ansi16 ansi16;
                    Color it;
                    TextStyle textStyle2;
                    TextStyle textStyle3 = style;
                    Color color4 = style.getColor();
                    if (color4 != null) {
                        Color color5 = color4;
                        textStyle2 = textStyle3;
                        boolean bl = false;
                        ansi16 = it instanceof Ansi16 ? (Ansi16)it : it.toSRGB().clamp().toAnsi16();
                        textStyle3 = textStyle2;
                    } else {
                        ansi16 = null;
                    }
                    Color color6 = ansi16;
                    Color color7 = style.getBgColor();
                    if (color7 != null) {
                        it = color7;
                        color3 = color6;
                        textStyle2 = textStyle3;
                        boolean bl = false;
                        color2 = it instanceof Ansi16 ? (Ansi16)it : it.toSRGB().clamp().toAnsi16();
                        textStyle3 = textStyle2;
                        color6 = color3;
                        color = color2;
                    } else {
                        color = null;
                    }
                    String string2 = string = style.getHyperlink();
                    color2 = color;
                    color3 = color6;
                    textStyle2 = textStyle3;
                    boolean bl = false;
                    boolean bl2 = hyperlinks;
                    String string3 = bl2 ? string : null;
                    String it2 = string = style.getHyperlinkId();
                    String string4 = string3;
                    boolean bl3 = false;
                    boolean bl4 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle2, color3, color2, string4, bl4 ? string : null);
                    break;
                }
                case 3: {
                    String string;
                    Color color;
                    Color color8;
                    Color color9;
                    Color color10;
                    Color it;
                    TextStyle textStyle4;
                    TextStyle textStyle5 = style;
                    Color color11 = style.getColor();
                    if (color11 != null) {
                        Color bl3 = color11;
                        textStyle4 = textStyle5;
                        boolean bl = false;
                        color10 = it instanceof Ansi16 || it instanceof Ansi256 ? it : (Color)it.toSRGB().clamp().toAnsi256();
                        textStyle5 = textStyle4;
                    } else {
                        color10 = null;
                    }
                    Color color12 = style.getBgColor();
                    if (color12 != null) {
                        it = color12;
                        color9 = color10;
                        textStyle4 = textStyle5;
                        boolean bl = false;
                        color8 = it instanceof Ansi16 || it instanceof Ansi256 ? it : (Color)it.toSRGB().clamp().toAnsi256();
                        textStyle5 = textStyle4;
                        color10 = color9;
                        color = color8;
                    } else {
                        color = null;
                    }
                    String it3 = string = style.getHyperlink();
                    color8 = color;
                    color9 = color10;
                    textStyle4 = textStyle5;
                    boolean bl = false;
                    boolean bl5 = hyperlinks;
                    String string5 = bl5 ? string : null;
                    it3 = string = style.getHyperlinkId();
                    String string6 = string5;
                    boolean bl6 = false;
                    boolean bl7 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle4, color9, color8, string6, bl7 ? string : null);
                    break;
                }
                case 4: {
                    if (hyperlinks || style.getHyperlink() == null) {
                        textStyle = style;
                        break;
                    }
                    textStyle = TextStyleKt.copy(style, style.getColor(), style.getBgColor(), null, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return textStyle;
    }

    private static final String makeTag(TextStyle old, TextStyle textStyle) {
        if (Intrinsics.areEqual(old, textStyle)) {
            return "";
        }
        List codes = new ArrayList();
        if (!Intrinsics.areEqual(old.getColor(), textStyle.getColor())) {
            CollectionsKt.addAll((Collection)codes, (Iterable)AnsiRenderKt.toAnsi(textStyle.getColor(), 38, 39, 0));
        }
        if (!Intrinsics.areEqual(old.getBgColor(), textStyle.getBgColor())) {
            CollectionsKt.addAll((Collection)codes, (Iterable)AnsiRenderKt.toAnsi(textStyle.getBgColor(), 48, 49, 10));
        }
        AnsiRenderKt.makeTag$style(codes, old.getItalic(), textStyle.getItalic(), 3, 23);
        AnsiRenderKt.makeTag$style(codes, old.getUnderline(), textStyle.getUnderline(), 4, 24);
        AnsiRenderKt.makeTag$style(codes, old.getInverse(), textStyle.getInverse(), 7, 27);
        AnsiRenderKt.makeTag$style(codes, old.getStrikethrough(), textStyle.getStrikethrough(), 9, 29);
        if (Intrinsics.areEqual(old.getBold(), true) && !Intrinsics.areEqual(textStyle.getBold(), true) || Intrinsics.areEqual(old.getDim(), true) && !Intrinsics.areEqual(textStyle.getDim(), true)) {
            ((Collection)codes).add(22);
            if (Intrinsics.areEqual(textStyle.getBold(), true)) {
                ((Collection)codes).add(1);
            }
            if (Intrinsics.areEqual(textStyle.getDim(), true)) {
                ((Collection)codes).add(2);
            }
        } else {
            AnsiRenderKt.makeTag$style(codes, old.getBold(), textStyle.getBold(), 1, 22);
            AnsiRenderKt.makeTag$style(codes, old.getDim(), textStyle.getDim(), 2, 22);
        }
        String csi = codes.isEmpty() ? "" : CollectionsKt.joinToString$default(codes, ";", "\u001b[", "m", 0, null, null, 56, null);
        return !Intrinsics.areEqual(old.getHyperlink(), textStyle.getHyperlink()) && !Intrinsics.areEqual(textStyle.getHyperlink(), "__mordant_reset__") ? csi + AnsiRenderKt.makeHyperlinkTag(textStyle.getHyperlink(), textStyle.getHyperlinkId()) : csi;
    }

    private static final String makeHyperlinkTag(String hyperlink, String hyperlinkId) {
        String string;
        block5: {
            block4: {
                if (hyperlink == null) {
                    return "\u001b]8;;\u001b\\";
                }
                string = hyperlinkId;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                String string2 = "id=" + it;
                string = string2;
                if (string2 != null) break block5;
            }
            string = "";
        }
        String id = string;
        return "\u001b]8;" + id + ';' + hyperlink + "\u001b\\";
    }

    private static final List<Integer> toAnsi(Color $this$toAnsi, int select, int reset, int offset) {
        List<Integer> list;
        Object it;
        Object object = $this$toAnsi instanceof TextStyle ? (TextStyle)((Object)$this$toAnsi) : null;
        if (object == null || (object = object.getColor()) == null) {
            object = $this$toAnsi;
        }
        if ((it = object) == null) {
            list = CollectionsKt.listOf(reset);
        } else if (it instanceof Ansi16) {
            switch (((Ansi16)it).getCode()) {
                case 39: 
                case 49: {
                    list = CollectionsKt.listOf(reset);
                    break;
                }
                default: {
                    list = CollectionsKt.listOf(((Ansi16)it).getCode() + offset);
                    break;
                }
            }
        } else if (it instanceof Ansi256) {
            Integer[] integerArray = new Integer[]{select, 5, ((Ansi256)it).getCode()};
            list = CollectionsKt.listOf(integerArray);
        } else {
            RGB $this$toAnsi_u24lambda_u2411 = it.toSRGB().clamp();
            boolean bl = false;
            Integer[] integerArray = new Integer[]{select, 2, $this$toAnsi_u24lambda_u2411.getRedInt(), $this$toAnsi_u24lambda_u2411.getGreenInt(), $this$toAnsi_u24lambda_u2411.getBlueInt()};
            list = CollectionsKt.listOf(integerArray);
        }
        return list;
    }

    private static final CharSequence invokeStyle$lambda$1(String $text, Ref.ObjectRef $style, TextStyle $this_invokeStyle, Ref.ObjectRef $openStyle, MatchResult match) {
        Intrinsics.checkNotNullParameter($text, "$text");
        Intrinsics.checkNotNullParameter($style, "$style");
        Intrinsics.checkNotNullParameter($this_invokeStyle, "$this_invokeStyle");
        Intrinsics.checkNotNullParameter($openStyle, "$openStyle");
        Intrinsics.checkNotNullParameter(match, "match");
        if (match.getRange().getLast() == StringsKt.getLastIndex($text)) {
            return "";
        }
        TextStyle textStyle = ParsingKt.updateStyle((TextStyle)$style.element, $this_invokeStyle, match.getValue());
        if (match.getRange().getFirst() == 0) {
            $openStyle.element = textStyle.plus($this_invokeStyle);
            $style.element = textStyle.plus($this_invokeStyle);
            return "";
        }
        String tag = AnsiRenderKt.makeTag((TextStyle)$style.element, textStyle);
        $style.element = textStyle;
        return tag;
    }

    private static final void makeTag$style(List<Integer> codes, Boolean old, Boolean bl, int open2, int close2) {
        if (!Intrinsics.areEqual(old, true) && Intrinsics.areEqual(bl, true)) {
            Integer n = open2;
            ((Collection)codes).add(n);
        } else if (Intrinsics.areEqual(old, true) && !Intrinsics.areEqual(bl, true)) {
            Integer n = close2;
            ((Collection)codes).add(n);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnsiLevel.values().length];
            try {
                nArray[AnsiLevel.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnsiLevel.ANSI16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnsiLevel.ANSI256.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnsiLevel.TRUECOLOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

